<?php
/*
Plugin Name: Overlay Image Divi Module
Plugin URI:  http://learnhowwp.com/divi-overlay-images
Description: This plugins adds a new module in the Divi Builder. The module allows you add text when you hover over an image. There are two effects that you can choose for the overlay, Fade and Slide.
Version:     1.0.1
Author:      learnhowwp.com
Author URI:  http://learnhowwp.com/
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: lwp-overlay-images
Domain Path: /languages

LWP Overlay Images is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

LWP Overlay Images is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with LWP Overlay Images. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
*/


if ( ! function_exists( 'lwp_initialize_overlay_image_extension' ) ):
/**
 * Creates the extension's main class instance.
 *
 * @since 1.0.0
 */
function lwp_initialize_overlay_image_extension() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/LwpOverlayImages.php';
}
add_action( 'divi_extensions_init', 'lwp_initialize_overlay_image_extension' );
endif;



function lwp_overlay_image_dependencies() {
  if( ! function_exists('et_builder_options'))
    echo '<div class="notice notice-warning"><p>' . __( 'The Divi Overlay Image Module needs the Divi Theme or the Divi Plugin to function', 'lwp-divi-breadcrumbs' ) . '</p></div>';
}

add_action( 'admin_notices', 'lwp_overlay_image_dependencies' );