<?php

class LWP_OverlayImages extends ET_Builder_Module {

	public $slug       = 'lwp_overlay_image';
	public $vb_support = 'on';

	protected $module_credits = array(
		'module_uri' => 'http://learnhowwp.com/divi-overlay-images',
		'author'     => 'learnhowwp.com',
		'author_uri' => 'http://learnhowwp.com/',
	);

	public function init() {
		$this->name = esc_html__( 'Overlay Image', 'lwp-overlay-images' );

		$this->settings_modal_toggles = array(
			'general'  => array(
				'toggles' => array(
					'main_content' => esc_html__( 'Content', 'lwp-overlay-images' ),
				),
			),
		);
	}


	public function get_fields() {
		$et_accent_color = et_builder_accent_color();

		$fields =  array(
			'content' => array(
				'label'           => esc_html__( 'Content', 'lwp-overlay-images' ),
				'type'            => 'tiny_mce',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Content entered here will appear inside the module.', 'lwp-overlay-images' ),
				'toggle_slug'     => 'main_content',
			),
			'src' => array(
				'label'              => esc_html__( 'Image', 'lwp-overlay-images' ),
				'type'               => 'upload',
				'option_category'    => 'basic_option',
				'upload_button_text' => esc_attr__( 'Upload an image', 'lwp-overlay-images' ),
				'choose_text'        => esc_attr__( 'Choose an Image', 'lwp-overlay-images' ),
				'update_text'        => esc_attr__( 'Set As Image', 'lwp-overlay-images' ),
				'hide_metadata'      => true,
				'affects'            => array(
					'alt',
					'title_text',
				),
				'description'        => esc_html__( 'Upload your desired image, or type in the URL to the image you would like to display.', 'lwp-overlay-images' ),
				'toggle_slug'        => 'main_content',
			),
			'overlay_color' => array(
				'default'           => 'rgba(0,0,0,0.5)',
				'label'             => esc_html__('Overlay Color', 'lwp-overlay-images' ),
				'type'              => 'color-alpha',
				'description'       => esc_html__( 'Here you can define a custom color for the overlay.', 'lwp-overlay-images' ),
				'toggle_slug'       => 'main_content',
			),
			'overlay_effect' => array(
				'label'             => esc_html__('Overlay Effect', 'lwp-overlay-images' ),
				'type'              => 'select',
				'description'       => esc_html__( 'Here you can define the Effect for the Overlay', 'lwp-overlay-images' ),
				'toggle_slug'       => 'main_content',
				'options'         => array(
					'fade' => esc_html__( 'Fade', 'lwp-overlay-images' ),
					'slide'  => esc_html__( 'Slide', 'lwp-overlay-images' ),
				),
				'default_on_front'=> 'fade',								
			),
			'slide_direction' => array(
				'label'             => esc_html__('Slide Direction', 'lwp-overlay-images' ),
				'type'              => 'select',
				'description'       => esc_html__( 'Here you can define the Direction for the Slide Effect', 'lwp-overlay-images' ),
				'toggle_slug'       => 'main_content',
				'options'         => array(
					'top' => esc_html__( 'Top', 'lwp-overlay-images' ),
					'bottom'  => esc_html__( 'Bottom', 'lwp-overlay-images' ),
					'left' => esc_html__( 'Left', 'lwp-overlay-images' ),
					'right'  => esc_html__( 'Right', 'lwp-overlay-images' ),
				),
				'default_on_front'=> 'top',
				'show_if'         => array(
					'overlay_effect' => 'slide',
				),																
			),
			'transition_duration' => array(
				'label'             => esc_html__('Transition Duration', 'lwp-overlay-images' ),
				'type'              => 'range',
				'description'       => esc_html__( 'Here you can define the Duration for the Transition', 'lwp-overlay-images' ),
				'toggle_slug'       => 'main_content',
				'range_settings'         => array(
					'min' => '100',
					'max'  => '10000',
					'step' => '100',
				),
				'validate_unit'=> 'true',
				'allowed_units'   => array('ms'),
				'default_unit'    => 'ms',
				'default_on_front'=> 500,								
			),
			'alt' => array(
				'label'           => esc_html__( 'Image Alternative Text', 'lwp-overlay-images' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter the Alt text for the image here', 'lwp-overlay-images' ),
				'toggle_slug'     => 'attributes',
			),
			'title' => array(
				'label'           => esc_html__( 'Image Title Text', 'lwp-overlay-images' ),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__( 'Enter the text for the Title attribute for the image here', 'lwp-overlay-images' ),
				'toggle_slug'     => 'attributes',
			),																									
		);

		return $fields;
	}

	public function render( $attrs, $content = null, $render_slug ) {

		$text = $this->props['content'];  
		$img_src = $this->props['src'];
		$overlay_color = $this->props['overlay_color'];
		$overlay_effect = $this->props['overlay_effect'];
		$slide_direction = $this->props['slide_direction'];
		$transition_duration = $this->props['transition_duration'];
		$alt = $this->props['alt'];
		$title = $this->props['title'];

		ET_Builder_Element::set_style( $render_slug, array(
			'selector'    => '%%order_class%% .overlay',
			'declaration' => sprintf('background:%1$s; transition:%2$s;',esc_attr($overlay_color), esc_attr($transition_duration)),
		) );
	
		
		return sprintf( 
		'<div class="container %4$s">
			<img src="%2$s" class="image" alt="%5$s" title="%6$s">
			<div class="overlay %3$s %4$s">
				<div class="text">%1$s</div>
			</div>
		</div>'
		, $text, esc_attr($img_src), esc_attr($overlay_effect), esc_attr($slide_direction), esc_attr($alt),esc_attr($title) );
	}
}

new LWP_OverlayImages;
